local t = LoadFallbackB();
local ScoreLabels = { "(PERFECT) W1", "(PERFECT) W2", "(GREAT) W3", "(GOOD) W4", "(BAD) W5", "MISS", "HOLD" }
local MQValues = {10, 9, 6, 3, 0, 0, 3}
local SM5Score = {3, 2, 1, 0, 0, 0, 3}
local SM5Grade = {2, 2, 1, 0, -4, -8, 6}

local cScores = {
	THEME:GetMetric("ScoreKeeperNormal","PercentScoreWeightW1"),
	THEME:GetMetric("ScoreKeeperNormal","PercentScoreWeightW2"),
	THEME:GetMetric("ScoreKeeperNormal","PercentScoreWeightW3"),
	THEME:GetMetric("ScoreKeeperNormal","PercentScoreWeightW4"),
	THEME:GetMetric("ScoreKeeperNormal","PercentScoreWeightW5"),
	THEME:GetMetric("ScoreKeeperNormal","PercentScoreWeightMiss"),
	THEME:GetMetric("ScoreKeeperNormal","PercentScoreWeightHeld")
}

local cGrades = {
	THEME:GetMetric("ScoreKeeperNormal","GradeWeightW1"),
	THEME:GetMetric("ScoreKeeperNormal","GradeWeightW2"),
	THEME:GetMetric("ScoreKeeperNormal","GradeWeightW3"),
	THEME:GetMetric("ScoreKeeperNormal","GradeWeightW4"),
	THEME:GetMetric("ScoreKeeperNormal","GradeWeightW5"),
	THEME:GetMetric("ScoreKeeperNormal","GradeWeightMiss"),
	THEME:GetMetric("ScoreKeeperNormal","GradeWeightHeld")
}

t[#t+1] = Def.ActorFrame {
	CommonNormal()..{
		Text="CURRENT SCORE WEIGHTS";
		InitCommand=cmd(xy,CenterX()-172,Top()+48;zoom,0.5;valign,0;maxwidth,356);
	};
	CommonNormal()..{
		Text="CURRENT GRADE WEIGHTS";
		InitCommand=cmd(xy,CenterX()-172,CenterY()-4;zoom,0.5;valign,0;maxwidth,356);
	};
	CommonNormal()..{
		Text="Retrieved Values from metrics.ini";
		InitCommand=cmd(xy,CenterX()-172,Bottom()-58;zoom,0.5;valign,0;maxwidth,356);
	};
	CommonNormal()..{
		Text="Those Values will be used!";
		InitCommand=cmd(xy,CenterX()+172,Bottom()-58;zoom,0.5;valign,0;maxwidth,356);
	};
};

for i = 1,#ScoreLabels do
	t[#t+1] = Def.ActorFrame {
		CommonNormal()..{ -- Current Score Titles
			Text=ScoreLabels[i];
			InitCommand=cmd(xy,CenterX()-256,Top()+44+(24*i);zoom,0.5;align,0,0;maxwidth,356;diffuse,color(jColors[i]));
		};
		CommonNormal()..{ -- Current Score Values
			Text=cScores[i];
			InitCommand=cmd(xy,CenterX()-48,Top()+44+(24*i);zoom,0.5;valign,0;maxwidth,356;diffuse,Black());
		};
		CommonNormal()..{ -- Current Grade Titles
			Text=ScoreLabels[i];
			InitCommand=cmd(xy,CenterX()-256,CenterY()-8+(24*i);zoom,0.5;align,0,0;maxwidth,356;diffuse,color(jColors[i]));
		};
		CommonNormal()..{ -- Current Grade Values
			Text=cGrades[i];
			InitCommand=cmd(xy,CenterX()-48,CenterY()-8+(24*i);zoom,0.5;valign,0;maxwidth,356;diffuse,Black());
		};
		CommonNormal()..{ -- Target Score Titles
			Text=ScoreLabels[i];
			InitCommand=cmd(xy,CenterX()+256,Top()+44+(24*i);zoom,0.5;align,1,0;maxwidth,356;diffuse,color(jColors[i]));
		};
		CommonNormal()..{ -- Target Grade Titles
			Text=ScoreLabels[i];
			InitCommand=cmd(xy,CenterX()+256,CenterY()-8+(24*i);zoom,0.5;align,1,0;maxwidth,356;diffuse,color(jColors[i]));
		};
		Def.Quad{ -- Current Score Label Quads
			InitCommand=cmd(draworder,-1;xy,CenterX()-172,Top()+40+(24*i);valign,0;setsize,200,20;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),2)); 
		};
		Def.Quad{ -- Current Score Value Quads
			InitCommand=cmd(draworder,-1;xy,CenterX()-48,Top()+40+(24*i);valign,0;setsize,32,20;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3)); 
		};
		Def.Quad{ -- Current Grade Label Quads
			InitCommand=cmd(draworder,-1;xy,CenterX()-172,CenterY()-12+(24*i);valign,0;setsize,200,20;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),2)); 
		};
		Def.Quad{ -- Current Grade Value Quads
			InitCommand=cmd(draworder,-1;xy,CenterX()-48,CenterY()-12+(24*i);valign,0;setsize,32,20;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3)); 
		};
		Def.Quad{ -- Target Score Label Quads
			InitCommand=cmd(draworder,-1;xy,CenterX()+172,Top()+40+(24*i);valign,0;setsize,200,20;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),2)); 
		};
		Def.Quad{ -- Target Score Value Quads
			InitCommand=cmd(draworder,-1;xy,CenterX()+48,Top()+40+(24*i);valign,0;setsize,32,20;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3)); 
		};
		Def.Quad{ -- Target Grade Label Quads
			InitCommand=cmd(draworder,-1;xy,CenterX()+172,CenterY()-12+(24*i);valign,0;setsize,200,20;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),2)); 
		};
		Def.Quad{ -- Target Grade Value Quads
			InitCommand=cmd(draworder,-1;xy,CenterX()+48,CenterY()-12+(24*i);valign,0;setsize,32,20;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3)); 
		};
	};
end

local Option = ThemePrefs.Get("ScoreGradeWeights")
local TargetScoreText, TargetGradeText
local TargetScoreW1, TargetScoreW2, TargetScoreW3, TargetScoreW4, TargetScoreW5, TargetScoreMiss, TargetScoreHold
local TargetGradeW1, TargetGradeW2, TargetGradeW3, TargetGradeW4, TargetGradeW5, TargetGradeMiss, TargetGradeHold
local AbleToMoveLeft = (Option == "MQX") and 1 or 0
local AbleToMoveRight = (Option == "MQX") and 0 or 1

local function InitialScoreText() if Option == "MQX" then return "METRO QUAD X SCORE WEIGHTS" else return "STEPMANIA 5 SCORE WEIGHTS" end end
local function InitialGradeText() if Option == "MQX" then return "METRO QUAD X GRADE WEIGHTS" else return "STEPMANIA 5 GRADE WEIGHTS" end end

local function CurrentScoreTargetValue(i) if Option == "MQX" then return MQValues[i] else return SM5Score[i] end end
local function CurrentGradeTargetValue(i) if Option == "MQX" then return MQValues[i] else return SM5Grade[i] end end

local function TargetScoreCallback(event)
	local pn = event.PlayerNumber
	if event.type == "InputEventType_FirstPress" then
		if pn then
			if event.GameButton == "MenuLeft" then
				AbleToMoveLeft = AbleToMoveLeft - 1
				AbleToMoveRight = AbleToMoveRight + 1
				if AbleToMoveLeft >= 2 or AbleToMoveLeft <= -1 then AbleToMoveLeft = 1 AbleToMoveRight = 0 end
			end
			if event.GameButton == "MenuRight" then
				AbleToMoveLeft = AbleToMoveLeft + 1
				AbleToMoveRight = AbleToMoveRight - 1
				if AbleToMoveRight >= 2 or AbleToMoveRight <= -1 then AbleToMoveLeft = 0 AbleToMoveRight = 1 end
			end
			if AbleToMoveLeft > 0 then TargetScoreText:settext("METRO QUAD X SCORE WEIGHTS") else TargetScoreText:settext("STEPMANIA 5 SCORE WEIGHTS") end
			if AbleToMoveLeft > 0 then TargetGradeText:settext("METRO QUAD X GRADE WEIGHTS") else TargetGradeText:settext("STEPMANIA 5 GRADE WEIGHTS") end
			if AbleToMoveLeft > 0 then TargetScoreW1:settext(MQValues[1]) else TargetScoreW1:settext(SM5Score[1]) end
			if AbleToMoveLeft > 0 then TargetScoreW2:settext(MQValues[2]) else TargetScoreW2:settext(SM5Score[2]) end
			if AbleToMoveLeft > 0 then TargetScoreW3:settext(MQValues[3]) else TargetScoreW3:settext(SM5Score[3]) end
			if AbleToMoveLeft > 0 then TargetScoreW4:settext(MQValues[4]) else TargetScoreW4:settext(SM5Score[4]) end
			if AbleToMoveLeft > 0 then TargetScoreW5:settext(MQValues[5]) else TargetScoreW5:settext(SM5Score[5]) end
			if AbleToMoveLeft > 0 then TargetScoreMiss:settext(MQValues[6]) else TargetScoreMiss:settext(SM5Score[6]) end
			if AbleToMoveLeft > 0 then TargetScoreHold:settext(MQValues[7]) else TargetScoreHold:settext(SM5Score[7]) end
			if AbleToMoveLeft > 0 then TargetGradeW1:settext(MQValues[1]) else TargetGradeW1:settext(SM5Grade[1]) end
			if AbleToMoveLeft > 0 then TargetGradeW2:settext(MQValues[2]) else TargetGradeW2:settext(SM5Grade[2]) end
			if AbleToMoveLeft > 0 then TargetGradeW3:settext(MQValues[3]) else TargetGradeW3:settext(SM5Grade[3]) end
			if AbleToMoveLeft > 0 then TargetGradeW4:settext(MQValues[4]) else TargetGradeW4:settext(SM5Grade[4]) end
			if AbleToMoveLeft > 0 then TargetGradeW5:settext(MQValues[5]) else TargetGradeW5:settext(SM5Grade[5]) end
			if AbleToMoveLeft > 0 then TargetGradeMiss:settext(MQValues[6]) else TargetGradeMiss:settext(SM5Grade[6]) end
			if AbleToMoveLeft > 0 then TargetGradeHold:settext(MQValues[7]) else TargetGradeHold:settext(SM5Grade[7]) end
		end
	end
end

t[#t+1] = Def.ActorFrame {
	CommonNormal()..{
		Text=InitialScoreText();
		InitCommand=cmd(xy,CenterX()+172,Top()+48;zoom,0.5;valign,0;maxwidth,356);
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TargetScoreCallback) TargetScoreText=self end;
	};
	CommonNormal()..{
		Text=InitialGradeText();
		InitCommand=cmd(xy,CenterX()+172,CenterY()-4;zoom,0.5;valign,0;maxwidth,356);
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TargetScoreCallback) TargetGradeText=self end;
	};
	CommonNormal()..{
		Text=CurrentScoreTargetValue(1);
		InitCommand=cmd(xy,CenterX()+48,Top()+44+24;zoom,0.5;valign,0;diffuse,Black());
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TargetScoreCallback) TargetScoreW1=self end;
	};
	CommonNormal()..{
		Text=CurrentScoreTargetValue(2);
		InitCommand=cmd(xy,CenterX()+48,Top()+44+24*2;zoom,0.5;valign,0;diffuse,Black());
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TargetScoreCallback) TargetScoreW2=self end;
	};
	CommonNormal()..{
		Text=CurrentScoreTargetValue(3);
		InitCommand=cmd(xy,CenterX()+48,Top()+44+24*3;zoom,0.5;valign,0;diffuse,Black());
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TargetScoreCallback) TargetScoreW3=self end;
	};
	CommonNormal()..{
		Text=CurrentScoreTargetValue(4);
		InitCommand=cmd(xy,CenterX()+48,Top()+44+24*4;zoom,0.5;valign,0;diffuse,Black());
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TargetScoreCallback) TargetScoreW4=self end;
	};
	CommonNormal()..{
		Text=CurrentScoreTargetValue(5);
		InitCommand=cmd(xy,CenterX()+48,Top()+44+24*5;zoom,0.5;valign,0;diffuse,Black());
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TargetScoreCallback) TargetScoreW5=self end;
	};
	CommonNormal()..{
		Text=CurrentScoreTargetValue(6);
		InitCommand=cmd(xy,CenterX()+48,Top()+44+24*6;zoom,0.5;valign,0;diffuse,Black());
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TargetScoreCallback) TargetScoreMiss=self end;
	};
	CommonNormal()..{
		Text=CurrentScoreTargetValue(7);
		InitCommand=cmd(xy,CenterX()+48,Top()+44+24*7;zoom,0.5;valign,0;diffuse,Black());
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TargetScoreCallback) TargetScoreHold=self end;
	};
	CommonNormal()..{
		Text=CurrentGradeTargetValue(1);
		InitCommand=cmd(xy,CenterX()+48,CenterY()-8+24;zoom,0.5;valign,0;diffuse,Black());
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TargetScoreCallback) TargetGradeW1=self end;
	};
	CommonNormal()..{
		Text=CurrentGradeTargetValue(2);
		InitCommand=cmd(xy,CenterX()+48,CenterY()-8+24*2;zoom,0.5;valign,0;diffuse,Black());
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TargetScoreCallback) TargetGradeW2=self end;
	};
	CommonNormal()..{
		Text=CurrentGradeTargetValue(3);
		InitCommand=cmd(xy,CenterX()+48,CenterY()-8+24*3;zoom,0.5;valign,0;diffuse,Black());
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TargetScoreCallback) TargetGradeW3=self end;
	};
	CommonNormal()..{
		Text=CurrentGradeTargetValue(4);
		InitCommand=cmd(xy,CenterX()+48,CenterY()-8+24*4;zoom,0.5;valign,0;diffuse,Black());
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TargetScoreCallback) TargetGradeW4=self end;
	};
	CommonNormal()..{
		Text=CurrentGradeTargetValue(5);
		InitCommand=cmd(xy,CenterX()+48,CenterY()-8+24*5;zoom,0.5;valign,0;diffuse,Black());
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TargetScoreCallback) TargetGradeW5=self end;
	};
	CommonNormal()..{
		Text=CurrentGradeTargetValue(6);
		InitCommand=cmd(xy,CenterX()+48,CenterY()-8+24*6;zoom,0.5;valign,0;diffuse,Black());
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TargetScoreCallback) TargetGradeMiss=self end;
	};
	CommonNormal()..{
		Text=CurrentGradeTargetValue(7);
		InitCommand=cmd(xy,CenterX()+48,CenterY()-8+24*7;zoom,0.5;valign,0;diffuse,Black());
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TargetScoreCallback) TargetGradeHold=self end;
	};
};

return t